﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class ProductMeasurementDB
    {
        public static ProductMeasurement GetItem(Guid productMeasurementID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductMeasurementID", ((productMeasurementID != Guid.Empty && productMeasurementID != null) ? productMeasurementID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.RetrieveObject<ProductMeasurement>("spGetProductMeasurement", parameters);
            
        }

        public static List<ProductMeasurement> GetList(Guid productMeasurementID, string keyword)
        {
           List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductMeasurementID", ((productMeasurementID != Guid.Empty && productMeasurementID != null) ? productMeasurementID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.RetrieveList<ProductMeasurement>("spGetProductMeasurement", parameters);
            
        }

        public static DataTable GetDataTable(Guid productMeasurementID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductMeasurementID", ((productMeasurementID != Guid.Empty && productMeasurementID != null) ? productMeasurementID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.ExecuteDataTable("spGetProductMeasurement", parameters);
            
        }

        public static DataSet GetDataSet(Guid productMeasurementID, string keyword)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductMeasurementID", ((productMeasurementID != Guid.Empty && productMeasurementID != null) ? productMeasurementID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@Keyword", (string.IsNullOrEmpty(keyword) ? (object)DBNull.Value : keyword)));

                return SQLHelper.ExecuteDataSet("spGetProductMeasurement", parameters);
           
        }

        public static void Save(ProductMeasurement myProductMeasurement)
        {
            myProductMeasurement.Mode = ((myProductMeasurement.UniqueID != Guid.Empty && myProductMeasurement.UniqueID != null) ? GlobalConfigurations.Mode.Update : GlobalConfigurations.Mode.Insert);
            myProductMeasurement.UniqueID = ((myProductMeasurement.UniqueID != Guid.Empty && myProductMeasurement.UniqueID != null) ? myProductMeasurement.UniqueID : Guid.NewGuid());
            if (myProductMeasurement.Mode == GlobalConfigurations.Mode.Insert)
            {
                myProductMeasurement.IsActive = true;
            }
            
            List<SqlParameter> parameters = new List<SqlParameter>();
                parameters.Add(new SqlParameter("@ProductMeasurementID", myProductMeasurement.UniqueID));
                parameters.Add(new SqlParameter("@MeasurementName", (string.IsNullOrEmpty(myProductMeasurement.MeasurementName) ? (object)DBNull.Value : myProductMeasurement.MeasurementName)));
                parameters.Add(new SqlParameter("@SequenceNo", (myProductMeasurement.SequenceNo == 0) ? (object)DBNull.Value : myProductMeasurement.SequenceNo));
                parameters.Add(new SqlParameter("@CreatedBy", ((myProductMeasurement.UserAccountID != Guid.Empty && myProductMeasurement.UserAccountID != null) ? myProductMeasurement.UserAccountID : (object)DBNull.Value)));
                parameters.Add(new SqlParameter("@IsActive", myProductMeasurement.IsActive));
                //parameters.Add(new SqlParameter("@IsDeleted", myProductCategory.IsDeleted));
                parameters.Add(new SqlParameter("@Mode", myProductMeasurement.Mode));

                SQLHelper.ExecuteQuery("spAddOrUpdateProductMeasurement", parameters);
            
        }
    }
}
